(function ($) {
  "use strict";

  $('body').on('click', '.join-purchase-webinar', function (e) {
    e.preventDefault();
    var $this = $(this);
    var webinarId = $this.attr('data-webinar-id');
    loadingSwl();
    var data = {
      webinar_id: webinarId
    };
    $.post('/panel/webinars/purchases/getJoinInfo', data, function (result) {
      if (result && result.code === 200) {
        var session = result.session;
        var $html = '<div id="joinWebinarModalHtml">' + $('#joinWebinarModal').html() + '</div>';
        Swal.fire({
          html: $html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '48rem',
          onOpen: function onOpen() {
            var $modal = $('#joinWebinarModalHtml');
            Object.keys(session).forEach(function (key) {
              $modal.find('.js-join-session-' + key).val(session[key]);
            });
            $modal.find('.js-join-session-link-action').attr('href', session.link);
          }
        });
      }
    }).fail(function (err) {
      Swal.fire({
        icon: 'error',
        html: '<h3 class="font-20 text-center text-dark-blue">' + undefinedActiveSessionLang + '</h3>',
        showConfirmButton: false
      });
    });
  });
  $('body').on('change', '#conductedSwitch', function (e) {
    e.preventDefault();
    $(this).closest('form').trigger('submit');
  });
})(jQuery);
