/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!***************************************!*\
  !*** ./resources/js/panel/webinar.js ***!
  \***************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  if (jQuery().summernote) {
    makeSummernote($('#summernote'), 400);
  }
  $('body').on('click', '#sendForReview', function (e) {
    $(this).addClass('loadingbar primary').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(0);
    $('#webinarForm').trigger('submit');
  });
  $('body').on('click', '#saveAsDraft', function (e) {
    $(this).addClass('loadingbar primary').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(1);
    $('#webinarForm').trigger('submit');
  });
  $('body').on('click', '#getNextStep', function (e) {
    $(this).addClass('loadingbar primary').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(1);
    $('#getNext').val(1);
    $('#webinarForm').trigger('submit');
  });
  $('body').on('click', '.js-get-next-step', function (e) {
    e.preventDefault();
    if (!$(this).hasClass('active')) {
      $(this).addClass('loadingbar primary').prop('disabled', true);
      var step = $(this).attr('data-step');
      $('#getStep').val(step);
      $('#forDraft').val(1);
      $('#getNext').val(1);
      $('#webinarForm').trigger('submit');
    }
  });
  $('#partnerInstructorSwitch').on('change.bootstrapSwitch', function (e) {
    var isChecked = e.target.checked;
    if (isChecked) {
      $('#partnerInstructorInput').removeClass('d-none');
    } else {
      $('#partnerInstructorInput').addClass('d-none');
    }
  });
  function handleGetFiltersTitleFromTranslations(translations, defaultLocale) {
    var title = null;
    if (Object.keys(translations).length) {
      Object.keys(translations).forEach(function (key) {
        var translation = translations[key];
        if (translation.locale === defaultLocale) {
          title = translation.title;
        }
      });
      if (!title) {
        title = translations[0].title;
      }
    }
    return title;
  }
  $('body').on('change', '#categories', function (e) {
    e.preventDefault();
    var category_id = this.value;
    $.get('/panel/filters/get-by-category-id/' + category_id, function (result) {
      if (result && typeof result.filters !== "undefined" && result.filters.length) {
        var defaultLocale = result.defaultLocale;
        var html = '';
        Object.keys(result.filters).forEach(function (key) {
          var filter = result.filters[key];
          var options = [];
          if (filter.options.length) {
            options = filter.options;
          }
          var filterTitle = filter.title;
          if (!filterTitle && filter.translations) {
            filterTitle = handleGetFiltersTitleFromTranslations(filter.translations, defaultLocale);
          }
          html += '<div class="col-12 col-md-3">\n' + '<div class="webinar-category-filters">\n' + '<strong class="category-filter-title d-block">' + filterTitle + '</strong>\n' + '<div class="py-10"></div>\n' + '\n';
          if (options.length) {
            Object.keys(options).forEach(function (index) {
              var option = options[index];
              var optionTitle = option.title;
              if (!optionTitle && option.translations) {
                optionTitle = handleGetFiltersTitleFromTranslations(option.translations, defaultLocale);
              }
              html += '<div class="form-group mt-20 d-flex align-items-center justify-content-between">\n' + '<label class="cursor-pointer" for="filterOption' + option.id + '">' + optionTitle + '</label>\n' + '<div class="custom-control custom-checkbox">\n' + '<input type="checkbox" name="filters[]" value="' + option.id + '" class="custom-control-input" id="filterOption' + option.id + '">\n' + '<label class="custom-control-label" for="filterOption' + option.id + '"></label>\n' + '</div>\n' + '</div>\n';
            });
          }
          html += '</div></div>';
        });
        $('#categoriesFiltersContainer').removeClass('d-none');
        $('#categoriesFiltersCard').html(html);
      } else {
        $('#categoriesFiltersContainer').addClass('d-none');
        $('#categoriesFiltersCard').html('');
      }
    });
  });
  $('body').on('click', '.cancel-accordion', function (e) {
    e.preventDefault();
    $(this).closest('.accordion-row').remove();
  });
  function randomString() {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    for (var i = 0; i < 5; i++) text += possible.charAt(Math.floor(Math.random() * possible.length));
    return text;
  }

  /*
  *
  * */

  function handleFileFormSubmit(form, $this) {
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    var formData = new FormData();
    var s3Input = form.find('.js-s3-file-input');
    var hasFileForUpload = false;
    if (s3Input && s3Input.prop('files') && s3Input.prop('files')[0]) {
      formData.append('s3_file', s3Input.prop('files')[0]);
      hasFileForUpload = true;
    }
    var items = form.find('input, textarea, select').serializeArray();
    $.each(items, function () {
      formData.append(this.name, this.value);
    });
    var source = form.find('.js-file-storage').val();
    form.find('.progress').addClass('d-none');
    $.ajax({
      url: action,
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      cache: false,
      xhr: function xhr() {
        var xhr = new window.XMLHttpRequest();
        var percentComplete = 0;
        xhr.upload.addEventListener("progress", function (event) {
          if (event.lengthComputable && (source === "s3" || source === "secure_host") && hasFileForUpload) {
            percentComplete = event.loaded / event.total * 100;
            var percentage = Math.round(percentComplete) - 1;
            form.find('.progress').removeClass('d-none');
            var bar = form.find('.progress .progress-bar');
            bar.css("width", percentage + '%');
            bar.text(percentage + '%');
          }
        }, false);
        return xhr;
      },
      success: function success(result) {
        if (result && result.code === 200) {
          //window.location.reload();
          Swal.fire({
            icon: 'success',
            html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
            showConfirmButton: false,
            width: '25rem'
          });
          setTimeout(function () {
            window.location.reload();
          }, 500);
        }
      },
      error: function error(err) {
        $this.removeClass('loadingbar primary').prop('disabled', false);
        var errors = err.responseJSON;
        if (errors && errors.errors) {
          Object.keys(errors.errors).forEach(function (key) {
            var error = errors.errors[key];
            var element = form.find('.js-ajax-' + key);
            element.addClass('is-invalid');
            element.parent().find('.invalid-feedback').text(error[0]);
          });
        }
      }
    });
  }
  window.handleWebinarItemForm = function (form, $this) {
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('input').removeClass('is-invalid');
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.status === 'zoom_token_invalid') {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + errors.zoom_error_msg + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
      }
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('.js-ajax-' + key);
          if (key === 'zoom-not-complete-alert') {
            form.find('.js-zoom-not-complete-alert').removeClass('d-none');
          } else {
            element.addClass('is-invalid');
            element.parent().find('.invalid-feedback').text(error[0]);
          }
        });
      }
    });
  };

  /**
   * add ticket
   * */
  $('body').on('click', '#webinarAddTicket', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_ticket = $('#newTicketForm').html();
    add_ticket = add_ticket.replaceAll('record', key);
    $('#ticketsAccordion').prepend(add_ticket);
    resetDatePickers();
    feather.replace();
  });
  $('body').on('click', '.js-save-ticket', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.ticket-form');
    handleWebinarItemForm(form, $this);
  });

  /*
  * add chapter
  * */

  $('body').on('click', '.save-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.chapter-form');
    handleWebinarItemForm(form, $this);
  });
  $('body').on('click', '.js-add-chapter', function (e) {
    var $this = $(this);
    var webinarId = $this.attr('data-webinar-id');
    var type = $this.attr('data-type');
    var itemId = $this.attr('data-chapter');
    var locale = $this.attr('data-locale');
    var random = itemId ? itemId : randomString();
    var clone = $('#chapterModalHtml').clone();
    clone.removeClass('d-none');
    var cloneHtml = clone.prop('innerHTML');
    cloneHtml = cloneHtml.replaceAll('record', random);
    clone.html('<div id="chapterModal' + random + '">' + cloneHtml + '</div>');
    Swal.fire({
      html: clone,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '36rem',
      onOpen: function onOpen() {
        var modal = $('#chapterModal' + random);
        modal.find('input.js-chapter-webinar-id').val(webinarId);
        modal.find('input.js-chapter-type').val(type);
        if (itemId) {
          modal.find('.section-title').text(editChapterLang);
          var path = '/panel/chapters/' + itemId + '/update';
          modal.find('.chapter-form').attr('data-action', path);
          $.get('/panel/chapters/' + itemId + '?locale=' + locale, function (result) {
            if (result && result.chapter) {
              modal.find('.js-ajax-title').val(result.chapter.title);
              var status = modal.find('.js-chapter-status-switch');
              if (result.chapter.status === 'active') {
                status.prop('checked', true);
              } else {
                status.prop('checked', false);
              }
              var checkedAllContents = result.chapter.check_all_contents_pass && result.chapter.check_all_contents_pass !== "0";
              modal.find('.js-chapter-check-all-contents-pass').prop('checked', checkedAllContents);
              var localeSelect = modal.find('.js-chapter-locale');
              localeSelect.val(locale);
              localeSelect.addClass('js-webinar-content-locale');
              localeSelect.attr('data-id', itemId);
            }
          });
        }
      }
    });
  });
  $('body').on('click', '.js-add-course-content-btn, .add-new-interactive-file-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var type = $this.attr('data-type');
    var chapterId = $this.attr('data-chapter');
    var contentTagId = '#chapterContentAccordion' + chapterId;
    var key = randomString();
    var html = '';
    switch (type) {
      case 'file':
        var newFileForm = $('#newFileForm');
        newFileForm.find('.chapter-input').val(chapterId);
        html = newFileForm.html();
        html = html.replace(/record/g, key);
        $(contentTagId).prepend(html);
        break;
      case 'new_interactive_file':
        var newInteractiveFileForm = $('#newInteractiveFileForm');
        newInteractiveFileForm.find('.chapter-input').val(chapterId);
        html = newInteractiveFileForm.html();
        html = html.replace(/record/g, key);
        $(contentTagId).prepend(html);
        break;
      case 'session':
        var newSessionForm = $('#newSessionForm');
        newSessionForm.find('.chapter-input').val(chapterId);
        html = newSessionForm.html();
        html = html.replace(/record/g, key);
        $(contentTagId).prepend(html);
        break;
      case 'text_lesson':
        var newTextLessonForm = $('#newTextLessonForm');
        newTextLessonForm.find('.chapter-input').val(chapterId);
        html = newTextLessonForm.html();
        html = html.replace(/record/g, key);
        html = html.replaceAll('attachments-select2', 'attachments-select2-' + key);
        html = html.replaceAll('js-content-summernote', 'js-content-summernote-' + key);
        html = html.replaceAll('js-hidden-content-summernote', 'js-hidden-content-summernote-' + key);
        $(contentTagId).prepend(html);
        $('.attachments-select2-' + key).select2({
          multiple: true,
          width: '100%'
        });
        if (jQuery().summernote) {
          makeSummernote($('.js-content-summernote-' + key), 400, function (contents, $editable) {
            $('.js-hidden-content-summernote-' + key).val(contents);
          });
        }
        break;
      case 'assignment':
        var newAssignmentForm = $('#newAssignmentForm');
        newAssignmentForm.find('.chapter-input').val(chapterId);
        html = newAssignmentForm.html();
        html = html.replace(/record/g, key);
        $(contentTagId).prepend(html);
        break;
      case 'quiz':
        var newQuizForm = $('#newQuizForm');
        newQuizForm.find('.chapter-input').val(chapterId);
        html = newQuizForm.html();
        html = html.replace(/record/g, key);
        $(contentTagId).prepend(html);
        break;
    }
    resetDatePickers();
    feather.replace();
  });
  $('body').on('click', '.js-change-content-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr('data-item-id');
    var itemType = $this.attr('data-item-type');
    var chapterId = $this.attr('data-chapter-id');
    var random = randomString();
    var clone = $('#changeChapterModalHtml').clone();
    clone.removeClass('d-none');
    var cloneHtml = clone.prop('innerHTML');
    clone.html('<div id="changeChapterModalHtml' + random + '">' + cloneHtml + '</div>');
    Swal.fire({
      html: clone,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '36rem',
      onOpen: function onOpen() {
        var modal = $('#changeChapterModalHtml' + random);
        modal.find('input.js-item-id').val(itemId);
        modal.find('input.js-item-type').val(itemType);
        modal.find('.js-ajax-chapter_id').val(chapterId).change();
      }
    });
  });
  $('body').on('click', '.save-change-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.change-chapter-form');
    handleWebinarItemForm(form, $this);
  });

  /**
   * add webinar sessions
   * */

  $('body').on('click', '.js-save-session', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.session-form');
    handleWebinarItemForm(form, $this);
  });

  /**
   * add webinar sessions
   * */

  $('body').on('click', '.js-save-assignment', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.assignment-form');
    handleWebinarItemForm(form, $this);
  });
  $('body').on('click', '.js-save-file', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.file-form');
    handleFileFormSubmit(form, $this);
  });
  $('body').on('click', '.js-save-text_lesson', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.text_lesson-form');
    handleWebinarItemForm(form, $this);
  });
  function setSelect2() {
    var selectItem = $('body #prerequisitesAccordion .prerequisites-select2');
    if (selectItem.length) {
      selectItem.select2({
        minimumInputLength: 3,
        allowClear: true,
        ajax: {
          url: '/panel/webinars/search',
          dataType: 'json',
          type: "POST",
          quietMillis: 50,
          data: function data(params) {
            return {
              term: params.term,
              webinar_id: $(this).data('webinar-id')
            };
          },
          processResults: function processResults(data) {
            return {
              results: $.map(data, function (item) {
                return {
                  text: item.title,
                  id: item.id
                };
              })
            };
          }
        }
      });
    }
    if ($('.accordion-content-wrapper .attachments-select2').length) {
      $('.accordion-content-wrapper .attachments-select2').select2({
        multiple: true,
        width: '100%'
      });
    }
  }
  $(document).ready(function () {
    var summernoteTarget = $('.accordion-content-wrapper .js-content-summernote');
    if (summernoteTarget.length) {
      makeSummernote(summernoteTarget, 400, function (contents, $editable) {
        $('.js-hidden-content-summernote').val(contents);
      });
    }
    setTimeout(function () {
      setSelect2();
    }, 1000);
  });

  /**
   * add webinar prerequisites
   * */
  $('body').on('click', '#webinarAddPrerequisites', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_prerequisite = $('#newPrerequisiteForm').html();
    add_prerequisite = add_prerequisite.replaceAll('record', key);
    add_prerequisite = add_prerequisite.replaceAll('prerequisites-select2', 'prerequisites-select2-' + key);
    $('#prerequisitesAccordion').prepend(add_prerequisite);
    $('.prerequisites-select2-' + key).select2({
      placeholder: $(this).data('placeholder'),
      minimumInputLength: 3,
      allowClear: true,
      ajax: {
        url: '/panel/webinars/search',
        dataType: 'json',
        type: "POST",
        quietMillis: 50,
        data: function data(params) {
          return {
            term: params.term,
            webinar_id: $(this).data('webinar-id')
          };
        },
        processResults: function processResults(data) {
          return {
            results: $.map(data, function (item) {
              return {
                text: item.title,
                id: item.id
              };
            })
          };
        }
      }
    });
    feather.replace();
  });
  $('body').on('click', '.js-save-prerequisite', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.prerequisite-form');
    handleWebinarItemForm(form, $this);
  });

  /**
   * add webinar Related Courses
   * */
  $('body').on('click', '#webinarAddRelatedCourses', function (e) {
    e.preventDefault();
    var key = randomString();
    var add = $('#newRelatedCourseForm').html();
    add = add.replaceAll('record', key);
    add = add.replaceAll('relatedCourses-select2', 'panel-search-webinar-select2');
    $('#relatedCoursesAccordion').prepend(add);
    panelSearchWebinarSelect2();
    feather.replace();
  });
  $('body').on('click', '.js-save-related-course', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.related-course-form');
    handleWebinarItemForm(form, $this);
  });

  /**
   * add webinar FAQ
   * */
  $('body').on('click', '#webinarAddFAQ', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#newFaqForm').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#faqsAccordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '.js-save-faq', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.faq-form');
    handleWebinarItemForm(form, $this);
  });
  $('body').on('click', '#add_new_learning_materials', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#new_learning_materials_html').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#learning_materials_accordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '#add_new_company_logos', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#new_company_logos_html').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#company_logos_accordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '#add_new_requirements', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_faq = $('#new_requirements_html').html();
    add_faq = add_faq.replaceAll('record', key);
    $('#requirements_accordion').prepend(add_faq);
    feather.replace();
  });
  $('body').on('click', '.js-save-extra_description', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.extra_description-form');
    handleWebinarItemForm(form, $this);
  });

  /**
   * add webinar Quiz
   * */
  $('body').on('click', '#webinarAddQuiz', function (e) {
    e.preventDefault();
    var key = randomString();
    var add_quiz = $('#newQuizForm').html();
    add_quiz = add_quiz.replaceAll('record', key);
    $('#quizzesAccordion').prepend(add_quiz);
    feather.replace();
  });
  $('body').on('click', '.js-save-quiz', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.quiz-form');
    handleWebinarItemForm(form, $this);
  });
  $(document).ready(function () {
    var style = getComputedStyle(document.body);
    var primaryColor = style.getPropertyValue('--primary');
    function updateToDatabase(table, idString) {
      $.post('/panel/webinars/order-items', {
        table: table,
        items: idString
      }, function (result) {
        if (result && result.title && result.msg) {
          $.toast({
            heading: result.title,
            text: result.msg,
            bgColor: primaryColor,
            textColor: 'white',
            hideAfter: 10000,
            position: 'bottom-right',
            icon: 'success'
          });
        }
      });
    }
    function setSortable(target) {
      if (target.length) {
        target.sortable({
          group: 'no-drop',
          handle: '.move-icon',
          axis: "y",
          update: function update(e, ui) {
            var sortData = target.sortable('toArray', {
              attribute: 'data-id'
            });
            var table = e.target.getAttribute('data-order-table');
            updateToDatabase(table, sortData.join(','));
          }
        });
      }
    }
    var target = $('.draggable-lists');
    var target2 = $('.draggable-lists2');
    var target3 = $('.draggable-lists3');
    var items = [];
    var draggableContentLists = $('.draggable-content-lists');
    if (draggableContentLists.length) {
      var _iterator = _createForOfIteratorHelper(draggableContentLists),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          items.push($(item).attr('data-drag-class'));
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
    if (items.length) {
      var _iterator2 = _createForOfIteratorHelper(items),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _item = _step2.value;
          var tag = $('.' + _item);
          if (tag.length) {
            setSortable(tag);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
    setSortable(target);
    if (target2.length) {
      setSortable(target2);
    }
    if (target3.length) {
      setSortable(target3);
    }
  });
  function handleShowFileInputsBySource($form, source, fileType) {
    var featherIconsConf = {
      width: 20,
      height: 20
    };
    var icon = feather.icons['upload'].toSvg(featherIconsConf);
    var $fileTypeVolumeInputs = $form.find('.js-file-type-volume');
    var $volumeInputs = $form.find('.js-file-volume-field');
    var $typeInputs = $form.find('.js-file-type-field');
    var $downloadableInput = $form.find('.js-downloadable-input');
    var $onlineViewerInput = $form.find('.js-online_viewer-input');
    var $filePathInputGroup = $form.find('.js-file-path-input');
    var $s3FilePathInputGroup = $form.find('.js-s3-file-path-input');
    var $filePathButton = $form.find('.js-file-path-input button');
    var $filePathInput = $form.find('.js-file-path-input input');
    var $secureHostUploadTypeField = $form.find('.js-secure-host-upload-type-field');
    $filePathButton.addClass('panel-file-manager');
    $filePathInputGroup.removeClass('d-none');
    $s3FilePathInputGroup.addClass('d-none');
    $volumeInputs.addClass('d-none');
    $typeInputs.removeClass('d-none'); // parent is hidden or visible
    $secureHostUploadTypeField.addClass('d-none');
    $s3FilePathInputGroup.find('input').removeAttr("accept");
    switch (source) {
      case 'youtube':
      case 'vimeo':
      case 'iframe':
        $fileTypeVolumeInputs.addClass('d-none');
        $fileTypeVolumeInputs.find('select').val('');
        $downloadableInput.find('input').prop('checked', false);
        $downloadableInput.addClass('d-none');
        $onlineViewerInput.find('input').prop('checked', false);
        $onlineViewerInput.addClass('d-none');
        icon = feather.icons['link'].toSvg(featherIconsConf);
        $filePathButton.removeClass('panel-file-manager');
        break;
      case 'external_link':
      case 's3':
        $fileTypeVolumeInputs.removeClass('d-none');
        if (fileType && fileType === 'video') {
          $downloadableInput.removeClass('d-none');
        } else {
          $downloadableInput.find('input').prop('checked', false);
          $downloadableInput.addClass('d-none');
        }
        if (source === 'external_link') {
          icon = feather.icons['external-link'].toSvg(featherIconsConf);
          $filePathButton.removeClass('panel-file-manager');
          $volumeInputs.removeClass('d-none');
        } else if (source === 's3') {
          $filePathInputGroup.addClass('d-none');
          $s3FilePathInputGroup.removeClass('d-none');
        }
        if (fileType && fileType === 'pdf') {
          $onlineViewerInput.removeClass('d-none');
        } else {
          $onlineViewerInput.find('input').prop('checked', false);
          $onlineViewerInput.addClass('d-none');
        }
        break;
      case 'secure_host':
        $fileTypeVolumeInputs.addClass('d-none');
        $fileTypeVolumeInputs.find('select').val('');
        $filePathInputGroup.addClass('d-none');
        $s3FilePathInputGroup.removeClass('d-none');
        $downloadableInput.find('input').prop('checked', false);
        $downloadableInput.addClass('d-none');
        $onlineViewerInput.addClass('d-none');
        $secureHostUploadTypeField.removeClass('d-none');
        $s3FilePathInputGroup.find('input').attr('accept', "video/mp4,video/x-m4v,video/*");
        break;
      case 'google_drive':
        $fileTypeVolumeInputs.removeClass('d-none');
        $volumeInputs.removeClass('d-none');
        $downloadableInput.find('input').prop('checked', false);
        $downloadableInput.addClass('d-none');
        if (fileType && fileType === 'pdf') {
          $onlineViewerInput.removeClass('d-none');
        } else {
          $onlineViewerInput.find('input').prop('checked', false);
          $onlineViewerInput.addClass('d-none');
        }
        icon = feather.icons['box'].toSvg(featherIconsConf);
        $filePathButton.removeClass('panel-file-manager');
        break;
      case 'upload':
        $fileTypeVolumeInputs.removeClass('d-none');
        $downloadableInput.removeClass('d-none');
        if (fileType && fileType === 'pdf') {
          $onlineViewerInput.removeClass('d-none');
        } else {
          $onlineViewerInput.find('input').prop('checked', false);
          $onlineViewerInput.addClass('d-none');
        }
    }
    if (fileType && (fileType === 'image' || fileType === 'document' || fileType === 'powerpoint' || fileType === 'sound' || fileType === 'archive' || fileType === 'project')) {
      $downloadableInput.find('input').prop('checked', true);
      $downloadableInput.addClass('d-none');
    }
    if (icon) {
      $filePathButton.html(icon);
    }
    if (filePathPlaceHolderBySource) {
      $filePathInput.attr('placeholder', filePathPlaceHolderBySource[source]);
    }
  }
  function handleSecureHostUploadType($form, value) {
    var $pathInput = $form.find('.js-secure-host-path-input');
    var $uploadInput = $form.find('.js-s3-file-path-input');
    var $fileTypeVolumeInputs = $form.find('.js-file-type-volume');
    var $volumeInputs = $form.find('.js-file-volume-field');
    var $typeInputs = $form.find('.js-file-type-field');
    $typeInputs.addClass('d-none');
    if (value === "manual") {
      $fileTypeVolumeInputs.removeClass('d-none');
      $volumeInputs.removeClass('d-none');
      $pathInput.removeClass('d-none');
      $uploadInput.addClass('d-none');
    } else {
      $fileTypeVolumeInputs.addClass('d-none');
      $volumeInputs.addClass('d-none');
      $pathInput.addClass('d-none');
      $uploadInput.removeClass('d-none');
    }
  }
  $('body').on('change', '.js-secure-host-upload-type-field input', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var $form = $(this).closest('.file-form');
    handleSecureHostUploadType($form, value);
  });
  $('body').on('click', '.js-s3-file-path-input button', function () {
    var parent = $(this).closest('.js-s3-file-path-input');
    parent.find('input').trigger('click');
  });
  $('body').on('change', '.js-video-demo-source', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var $otherSources = $('.js-video-demo-other-inputs');
    var $secureHostSource = $('.js-video-demo-secure-host-input');
    if (value === "secure_host") {
      $otherSources.addClass('d-none');
      $secureHostSource.removeClass('d-none');
    } else {
      $otherSources.removeClass('d-none');
      $secureHostSource.addClass('d-none');
      var $filePathUploadButton = $('.js-video-demo-path-input .js-video-demo-path-upload');
      var $filePathLinkButton = $('.js-video-demo-path-input .js-video-demo-path-links');
      var $filePathInput = $('.js-video-demo-path-input input');
      $filePathUploadButton.addClass('d-none');
      $filePathLinkButton.addClass('d-none');
      if (value === 'upload') {
        $filePathUploadButton.removeClass('d-none');
      } else {
        $filePathLinkButton.removeClass('d-none');
      }
      if (videoDemoPathPlaceHolderBySource) {
        $filePathInput.attr('placeholder', videoDemoPathPlaceHolderBySource[value]);
      }
    }
  });
  $('body').on('change', '.js-file-storage', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var formGroup = $(this).closest('.file-form');
    var fileType = formGroup.find('.js-ajax-file_type').val();
    handleShowFileInputsBySource(formGroup, value, fileType);
  });
  $('body').on('change', '.js-ajax-file_type', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var formGroup = $(this).closest('.file-form');
    var source = formGroup.find('.js-file-storage').val();
    handleShowFileInputsBySource(formGroup, source, value);
  });
  $('body').on('change', '.js-api-input', function (e) {
    e.preventDefault();
    var sessionForm = $(this).closest('.session-form');
    var value = this.value;
    sessionForm.find('.js-zoom-not-complete-alert').addClass('d-none');
    sessionForm.find('.js-agora-chat-and-rec').addClass('d-none');
    if (value === 'big_blue_button') {
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-api-secret').removeClass('d-none');
      sessionForm.find('.js-moderator-secret').removeClass('d-none');
    } else if (value === 'zoom') {
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-api-secret').addClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
      if (hasZoomApiToken && hasZoomApiToken !== 'true') {
        sessionForm.find('.js-zoom-not-complete-alert').removeClass('d-none');
      }
    } else if (value === 'agora') {
      sessionForm.find('.js-agora-chat-and-rec').removeClass('d-none');
      sessionForm.find('.js-api-secret').addClass('d-none');
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
    } else if (value === 'jitsi') {
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-api-secret').addClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
    } else {
      sessionForm.find('.js-local-link').removeClass('d-none');
      sessionForm.find('.js-api-secret').removeClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
    }
  });
  $(document).ready(function () {
    var $fileForms = $('.file-form');
    if ($fileForms && $fileForms.length) {
      $fileForms.each(function (key) {
        if ($fileForms[key]) {
          var $form = $($fileForms[key]);
          var source = $form.find('.js-file-storage').val();
          var fileType = $form.find('.js-ajax-file_type').val();
          handleShowFileInputsBySource($form, source, fileType);
          var secureHostType = $form.find('.js-secure-host-upload-type-field input:checked').val();
          if (secureHostType && source === 'secure_host') {
            handleSecureHostUploadType($form, secureHostType);
          }
        }
      });
    }
  });
  $('body').on('change', '.js-interactive-type', function () {
    var fileForm = $(this).closest('.file-form');
    var $fileName = fileForm.find('.js-interactive-file-name-input');
    $fileName.addClass('d-none');
    if ($(this).val() === 'custom') {
      $fileName.removeClass('d-none');
    }
  });
  $('body').on('click', '.js-session-has-ended', function () {
    $.toast({
      heading: requestFailedLang,
      text: thisLiveHasEndedLang,
      bgColor: '#f63c3c',
      textColor: 'white',
      hideAfter: 10000,
      position: 'bottom-right',
      icon: 'error'
    });
  });
  $('body').on('change', '.js-sequence-content-switch', function () {
    var parent = $(this).closest('.accordion-row');
    var sequenceContentInputs = parent.find('.js-sequence-content-inputs');
    sequenceContentInputs.addClass('d-none');
    if (this.checked) {
      sequenceContentInputs.removeClass('d-none');
    }
  });
  $('body').on('click', '.assignment-attachments-add-btn', function (e) {
    var $container = $(this).closest('.js-assignment-attachments-items');
    var mainRow = $container.find('.assignment-attachments-main-row');
    var copy = mainRow.clone();
    copy.removeClass('assignment-attachments-main-row');
    copy.removeClass('d-none');
    var removeBtn = copy.find('.assignment-attachments-remove-btn');
    if (removeBtn) {
      removeBtn.removeClass('d-none');
    }
    var copyHtml = copy.prop('innerHTML');
    copyHtml = copyHtml.replaceAll('assignmentTemp', randomString());
    copyHtml = copyHtml.replaceAll('btn-primary', 'btn-danger');
    copyHtml = copyHtml.replaceAll('assignment-attachments-add-btn', 'assignment-attachments-remove-btn');
    copy.html(copyHtml);
    $container.append(copy);
  });
  $('body').on('click', '.assignment-attachments-remove-btn', function (e) {
    e.preventDefault();
    $(this).closest('.js-ajax-attachments').remove();
  });
})(jQuery);
/******/ })()
;