(function ($) {
  "use strict";

  var mapContainer = $('#contactMap');

  if (mapContainer && mapContainer.length) {
    var mapOption = {
      dragging: false,
      zoomControl: false,
      scrollWheelZoom: false
    };
    var lat = mapContainer.attr('data-latitude');
    var lng = mapContainer.attr('data-longitude');
    var zoom = mapContainer.attr('data-zoom');
    var contactMap = L.map('contactMap', mapOption).setView([lat, lng], zoom);
    L.tileLayer(leafletApiPath, {
      maxZoom: 18,
      tileSize: 512,
      zoomOffset: -1,
      attribution: '© <a target="_blank" rel="nofollow" href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
    }).addTo(contactMap);
    var myIcon = L.icon({
      iconUrl: '/assets/default/img/location.png',
      iconAnchor: [lat - 14, lng + 10]
    });
    L.marker([lat, lng], {
      color: '#43d477',
      icon: myIcon
    }).addTo(contactMap);
  }
})(jQuery);
