<?php

declare(strict_types=1);

namespace Saade\BladeIconsax;

use BladeUI\Icons\Factory;
use Illuminate\Contracts\Container\Container;
use Illuminate\Support\ServiceProvider;

final class BladeIconsaxServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->registerConfig();

        $this->callAfterResolving(Factory::class, function (Factory $factory, Container $container) {
            $config = $container->make('config')->get('blade-iconsax', []);

            $factory->add('iconsax', array_merge(['path' => __DIR__.'/../resources/svg'], $config));
        });
    }

    private function registerConfig(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../config/blade-iconsax.php', 'blade-iconsax');
    }

    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__.'/../resources/svg' => public_path('vendor/blade-iconsax'),
            ], 'blade-iconsax');

            $this->publishes([
                __DIR__.'/../config/blade-iconsax.php' => $this->app->configPath('blade-iconsax.php'),
            ], 'blade-iconsax-config');
        }
    }
}
