<?php
  declare(strict_types=1);

	namespace Redsys\Merchant;

	use ReflectionClass;

	class MerchantCurrencies {
		public const AED = '784'; // Dirham DE EAU
		public const AFN = '971'; // Afgani afgano
		public const ALL = '008'; // Lek
		public const AMD = '051'; // Dram armenio
		public const ANG = '532'; // Florín holandés
		public const AOA = '973'; // Kwanza angoleño
		public const ARS = '032'; // Peso argentino
		public const AUD = '036'; // Dólar australiano
		public const AWG = '533'; // Florín arubeño
		public const AZN = '944'; // Manat azerbaiyano
		public const BAM = '977'; // Marco bosnioherzegovino
		public const BBD = '052'; // Dólar de Barbados
		public const BDT = '050'; // Taka
		public const BGN = '975'; // Lev
		public const BHD = '048'; // Dinar bareiní
		public const BIF = '108'; // Franco burundés
		public const BMD = '060'; // Dólar bermudeño
		public const BND = '096'; // Dólar de Brunei
		public const BOB = '068'; // Boliviano
		public const BOV = '984'; // Mvdol
		public const BRL = '986'; // Real brasileño
		public const BSD = '044'; // Dólar bahameño
		public const BTN = '064'; // Ngultrum butanés
		public const BWP = '072'; // Pula
		public const BYR = '974'; // Rublo bielorruso
		public const BZD = '084'; // Dólar beliceño
		public const CAD = '124'; // Dólar canadiense
		public const CDF = '976'; // Franco congoleño
		public const CHE = '947'; // WIR Euro
		public const CHF = '756'; // Franco suizo
		public const CHW = '948'; // Franco WIR
		public const CLF = '990'; // Unidad de Fomento
		public const CLP = '152'; // Peso chileno
		public const CNY = '156'; // Renminbi
		public const COP = '170'; // Peso colombiano
		public const COU = '970'; // Unidad de valor real
		public const CRC = '188'; // Colón costarricense
		public const CUC = '931'; // Peso convertible
		public const CUP = '192'; // Peso cubano
		public const CVE = '132'; // Escudo caboverdiano
		public const CZK = '203'; // Czech Koruna
		public const DJF = '262'; // Franco yibutiano
		public const DKK = '208'; // Corona danesa
		public const DOP = '214'; // Peso dominicano
		public const DZD = '012'; // Dinar argelino
		public const EGP = '818'; // Libra egipcia
		public const ERN = '232'; // Nakfa
		public const ETB = '230'; // Birr etíope
		public const EUR = '978'; // Euro
		public const FJD = '242'; // Dólar fiyiano
		public const FKP = '238'; // Libra malvinense
		public const GBP = '826'; // Libra esterlina
		public const GEL = '981'; // Lari
		public const GHS = '936'; // Cedi
		public const GIP = '292'; // Libra gibraltareña
		public const GMD = '270'; // Dalasi
		public const GNF = '324'; // Franco guineano
		public const GTQ = '320'; // Quetzal
		public const GYD = '328'; // Dólar guyanés
		public const HKD = '344'; // Dólar de Hong Kong
		public const HNL = '340'; // Lempira
		public const HRK = '191'; // Kuna
		public const HTG = '332'; // Gourde
		public const HUF = '348'; // Forinto húngaro
		public const IDR = '360'; // Rupia indonesia
		public const ILS = '376'; // Nuevo séquel
		public const INR = '356'; // Rupia india
		public const IQD = '368'; // Dinar iraquí
		public const IRR = '364'; // Rial iraní
		public const ISK = '352'; // Corona islandesa
		public const JMD = '388'; // Dólar jamaiquino
		public const JOD = '400'; // Dinar jordano
		public const JPY = '392'; // Yen
		public const KES = '404'; // Chelín keniano
		public const KGS = '417'; // Som
		public const KHR = '116'; // Riel camboyano
		public const KMF = '174'; // Franco comorense
		public const KPW = '408'; // Won norcoreano
		public const KRW = '410'; // Won
		public const KWD = '414'; // Dinar kuwaití
		public const KYD = '136'; // Dólar de las Islas Cayman
		public const KZT = '398'; // Tenge kazajo
		public const LAK = '418'; // Kip laosiano
		public const LBP = '422'; // Libra libanesa
		public const LKR = '144'; // Rupia de Sri Lanka
		public const LRD = '430'; // Dólar liberiano
		public const LSL = '426'; // Loti
		public const LYD = '434'; // Dinar libio
		public const MAD = '504'; // Dirham marroquí
		public const MDL = '498'; // Leu Moldavo
		public const MGA = '969'; // Ariary malgache
		public const MKD = '807'; // Dinar
		public const MMK = '104'; // Kyat birmano
		public const MNT = '496'; // Tugrik
		public const MOP = '446'; // Pataca
		public const MRO = '478'; // Uguiya
		public const MUR = '480'; // Rupia de Mauricio
		public const MVR = '462'; // Rupia de maldivas
		public const MWK = '454'; // Kwacha malauí
		public const MXN = '484'; // Peso mexicano
		public const MXV = '979'; // Unidad de Inversion Mexicana(UDI)
		public const MYR = '458'; // Ringgit malayo
		public const MZN = '943'; // Metical mozambiqueño
		public const NAD = '516'; // Dólar de Namibia
		public const NGN = '566'; // Naira
		public const NIO = '558'; // Córdoba oro
		public const NOK = '578'; // Corona noruega
		public const NPR = '524'; // Rupia nepalí
		public const NZD = '554'; // Dólar neozelandés
		public const OMR = '512'; // Rial omaní
		public const PAB = '590'; // Balboa
		public const PEN = '604'; // Nuevo Sol
		public const PGK = '598'; // Kina
		public const PHP = '608'; // Peso filipino
		public const PKR = '586'; // Rupia pakistaní
		public const PLN = '985'; // Zloty
		public const PYG = '600'; // Guaraní
		public const QAR = '634'; // Riyal catarí
		public const RON = '946'; // Leu rumano
		public const RSD = '941'; // Dinar serbio
		public const RUB = '643'; // Rublo ruso
		public const RWF = '646'; // Franco ruandés
		public const SAR = '682'; // Riyal saudí
		public const SBD = '090'; // Dólar de Islas Salomón
		public const SCR = '690'; // Rupia de Seychelles
		public const SDG = '938'; // Libra sudanesa
		public const SEK = '752'; // Corona sueca
		public const SGD = '702'; // Dólar de Singapur
		public const SHP = '654'; // Libra de Santa Helena
		public const SLL = '694'; // Leone
		public const SOS = '706'; // Chelín somalí
		public const SRD = '968'; // Dólar de Surinam
		public const SSP = '728'; // Libra sursudanesa
		public const STD = '678'; // Dobra
		public const SVC = '222'; // Colón
		public const SYP = '760'; // Libra siria
		public const SZL = '748'; // Lilangeni
		public const THB = '764'; // Baht
		public const TJS = '972'; // Somoni
		public const TMT = '934'; // Manat turcomano
		public const TND = '788'; // Dinar tunecino
		public const TOP = '776'; // Pa’anga
		public const TRY = '949'; // Lira turca
		public const TTD = '780'; // Dólar de Trinidad y Tobago
		public const TWD = '901'; // Nuevo dólar de Taiwán
		public const TZS = '834'; // Chelín tanzano
		public const UAH = '980'; // Grivnia
		public const UGX = '800'; // Chelín ugandés
		public const USD = '840'; // Dólar estadounidense
		public const USN = '997'; // Dólar estadounidense (Next day)
		public const UYI = '940'; // Peso uruguayo en unidades indexadas (URUIURUI)
		public const UYU = '858'; // Peso uruguayo
		public const UZS = '860'; // Som uzbeko
		public const VEF = '937'; // Bolívar
		public const VND = '704'; // Dong
		public const VUV = '548'; // Vatu
		public const WST = '882'; // Tala
		public const XAF = '950'; // Franco CFA de África Central
		public const XCD = '951'; // Dólar del Caribe Oriental
		public const XDR = '960'; // SDR (Derecho Especial de Retiro)
		public const XOF = '952'; // Franco CFA de África Occidental
		public const XPF = '953'; // Franco CFP
		public const XSU = '994'; // Sucre
		public const XUA = '965'; // BAD UNIDAD DE CUENTAS
		public const YER = '886'; // Rial yemení
		public const ZAR = '710'; // Rand
		public const ZMW = '967'; // Kwacha zambiano
		public const ZWL = '932'; // Dólar zimbabuense

		public static function isValid (string $value) : bool {
			return in_array($value, (new ReflectionClass(self::class))->getConstants());
		}
	}
